﻿//////////////////////////////////////////////
// ConversionUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Data/AlignmentDescriptor.h"
#include "../Data/Image.h"
#include "../Data/ImageView.h"

#include "../Dll/DllDefines.h"

#include "../Enums/PixelFormat.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

/// Class ------------------------------------

namespace nkImages
{
	class DLL_IMAGES_EXPORT ConversionUtils final
	{
		public :

			// Conversions
			static nkMaths::Vector convertPixel (const nkMaths::Vector& pix, PIXEL_FORMAT inFormat, PIXEL_FORMAT outFormat) ;
			static Image convertImage (const ImageView& image, PIXEL_FORMAT outFormat, const AlignmentDescriptor& alignmentDescriptor = AlignmentDescriptor()) ;
	} ;
}